<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class BasicDataController extends Controller
{


    public function __construct()
    {
        parent::__construct();
    }

    public function store()
    {
        $validate_result = $this->validateData([
            "name" => "required",
            "type" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = DB::table(request("type"))->insert(
            ['name' => request("name")]
        );


        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                request("type") . " is Saved",
                DB::table(request("type"))->orderBy("id", "desc")->first()
            )
        );
    }

    public function get()
    {

        $validate_result = $this->validateData([
            "type" => "required",

        ], request()->all());
        if ($validate_result) return $this->showValidateError();


        $result =  DB::table(request("type"))->where("status", 1)->get();
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All " . request("type"),
                $result
            )
        );
    }

    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
            "type" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = DB::table(request("type"))->where(request("column"), request("value"))->first();

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, request("type") . " by " . request("column"), $result)
        );
    }


    public function update()
    {
        $validate_result = $this->validateData([
            "id" => "required",
            "name" => "required",
            "type" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = DB::table(request("type"))->where("id", request("id"))->update([
            "name" => request("name")
        ]);
        $result = DB::table(request("type"))->where("id", request("id"))->first();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, request("type") . " is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
            "type" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = DB::table(request("type"))->where("id", request("id"))->update([
            "status" => 0
        ]);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DA is deleted", $result)
        );
    }
}
