<?php

namespace App\Http\Controllers\Dashboard;

use App\Admin;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;

class AdminController extends Controller
{
    private $adminService;

    public function __construct()
    {
        parent::__construct();
        $this->adminService = new \App\Service\Dashboard\Admin;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            "name" => "required",
            "email" => "required",
            "role" => "required"
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->adminService->save(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Admin is Saved", $result)
        );
    }

    public function get()
    {
        $result =  $this->adminService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Admins",
                $result
            )
        );
    }

    public function getEach()
    {
        
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->adminService->getEach(request("column"), request("value"));
       
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Admin by " . request("column"), $result));
    }


    public function update()
    {
        $validate_result = $this->validateData([
            "id" => "required",
            "name" => "required",
            "email" => "required",
            "role" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->adminService->update(request()->all());
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Admin is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->adminService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Township is deleted", $result)
        );
    }

}
