<?php

namespace App\Http\Controllers\DA;

use App\Http\Controllers\Controller;

class VolunteerTrainingController extends Controller
{
    private $volunteerTrainingService;

    public function __construct()
    {
        parent::__construct();
        $this->volunteerTrainingService = new \App\Service\PA\VolunteerTraining;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'date' => 'required',
            'training_type_id' => 'required',
            'volunteer_id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->volunteerTrainingService->save(request()->all());
        $result = $this->volunteerTrainingService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Volunteer is Saved", $result)
        );
    }

   

    public function get()
    {
        $result =  $this->volunteerTrainingService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All volunteers",
                $result
            )
        );
    }

    
    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->volunteerTrainingService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Volunteer is deleted", $result)
        );
    }

   
}
