<?php

namespace App\Http\Controllers\DA;

use App\Http\Controllers\Controller;

class SupervisionVisitActivityController extends Controller
{
    private $superVisionVisitService;

    public function __construct()
    {
        parent::__construct();
        $this->superVisionVisitService = new \App\Service\DA\SupervisionVisit;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'month' => 'required',
            'year' => 'required',
            'volunteer_id'=>'required',
            'patient_id'=>'required',
            "date" => 'required',
            "township_id" => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->superVisionVisitService->save(request()->all());
        $result = $this->superVisionVisitService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Visit is Saved", $result)
        );
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required",
            "township_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->superVisionVisitService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Supervision Visit Activities",
                $result
            )
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->superVisionVisitService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Visit by " . request("column"), $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'month' => 'required',
            'year' => 'required',
            'volunteer_id'=>'required',
            'patient_id'=>'required',
            "date" => 'required',
            'id' => 'required'
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->superVisionVisitService->update(request()->all());
        $result = $this->superVisionVisitService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Visit is Saved", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->superVisionVisitService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supervision Visit is deleted", $result)
        );
    }
}
