<?php

namespace App\Http\Controllers\DA;

use App\Http\Controllers\Controller;

class ReferPatientController extends Controller
{
    private $referPatientService;

    public function __construct()
    {
        parent::__construct();
        $this->referPatientService = new \App\Service\DA\ReferPatient;
        $this->presumptiveService = new \App\Service\DA\Presumptive;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            // 'name' => 'required',
            // 'sex' => 'required',
            // 'dob' => 'required',
            'volunteer_id' => 'required',
            'referral_date' => 'required',
            'case_found_at' => 'required',
            'township_id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->referPatientService->save(request()->all());
        $result = $this->referPatientService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Refer Patient is Saved", $result)
        );
    }

    public function get()
    {
      

        $result = $this->referPatientService->getAll(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Refer Patient by patient ID " . request("patient_id"), $result)
        );
    }


    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->referPatientService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Refer Patient by " . request("column"), $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'sex' => 'required',
            'age' => 'required',
            'volunteer_id' => 'required',
            'referral_date' => 'required',
            'case_found_at' => 'required',
            'id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->referPatientService->update(request()->all());
        $result = $this->referPatientService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Refer Patient is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->referPatientService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Refer Patient is deleted", $result)
        );
    }

    public function savePresumptive()
    {
        $validate_result = $this->validateData([
            'no' => 'required',
            'reg_date' => 'required',
            'referral_type_id' => 'required',
            'referral_from_id' => 'required',
            'symptons' => 'required',
            'risk_factors' => 'required',
            'hiv_status' => 'required',
            'sputum_status' => 'required',
            'cxr_status' => 'required',
            'gene_xpert_status' => 'required',
            'culture_status' => 'required',
            'dst_status' => 'required',
            'other_investigation_status' => 'required',
            'conclusion' => 'required',
            'township_id' => 'required',
            'id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->presumptiveService->saveAsPresumptive(request()->all());
        $result = $this->presumptiveService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Refer Patient is Saved", $result)
        );
    }

    

}
