<?php

namespace App\Http\Controllers\DA;

use App\Http\Controllers\Controller;

class PresumptiveDiagnosisController extends Controller
{
    private $diagnosisService;

    public function __construct()
    {
        parent::__construct();
        $this->diagnosisService = new \App\Service\DA\PresumptiveDiagnosis;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            // 'reg_date' => 'required',
            // 'referral_type_id' => 'required',
            // 'referral_from_id' => 'required',
            // 'symptons' => 'required',
            // 'risk_factors' => 'required',
            // 'hiv_status' => 'required',
            // 'sputum_status' => 'required',
            // 'cxr_status' => 'required',
            // 'gene_xpert_status' => 'required',
            // 'culture_status' => 'required',
            // 'dst_status' => 'required',
            // 'other_investigation_status' => 'required',
            // 'conclusion' => 'required',
            'presumptive_id' => 'required',
        ], request()->all());

        if ($validate_result) return $this->showValidateError();

        $result = $this->diagnosisService->addNew(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "New Diagnosis is Saved", $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'register_date' => 'required',
            'referral_type_id' => 'required',
            'referral_from_id' => 'required',
            'symptons' => 'required',
            'risk_factors' => 'required',
            'hiv_status' => 'required',
            'sputum_status' => 'required',
            'cxr_status' => 'required',
            'gene_xpert_status' => 'required',
            'culture_status' => 'required',
            'dst_status' => 'required',
            'other_investigation_status' => 'required',
            'conclusion' => 'required',
            'id' => 'required',
        ], request()->all());

        if ($validate_result) return $this->showValidateError();

        $result = $this->diagnosisService->update(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "New Diagnosis is Saved", $result)
        );
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "presumptive_id" => "required",

        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->diagnosisService->getAll(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Diagnosis List", $result)
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->diagnosisService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Diagnosis by " . request("column"), $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->diagnosisService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Diagnosis is deleted", $result)
        );
    }
    
     public function deleteEach()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->diagnosisService->deleteEach(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive Time is deleted", $result)
        );
    }
}
