<?php

namespace App\Http\Controllers\DA;

use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class PresumptiveController extends Controller
{
    private $presumptiveService;

    public function __construct()
    {
        parent::__construct();
        $this->presumptiveService = new \App\Service\DA\Presumptive;
        $this->ciService = new \App\Service\DA\Ci;
        
    }

    public function searchByIndexCode()
    {
    
        $validate_result = $this->validateData([
            "index_case_no" => "required",
            "index_case_year" => "required",
            "index_case_monopoly"=>"required",
            "township_id" => "required",
        ], request()->all());
        

        if ($validate_result) return $this->showValidateError();

        $result = $this->presumptiveService->getByIndexCode(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive by Index Code", $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'sex' => 'required',
            'age' => 'required',
            'no' => 'required',
            'case_found_at' => 'required',
            'id' => 'required',
        ], request()->all());

        if ($validate_result) return $this->showValidateError();

        $result = $this->presumptiveService->editInfo(request()->all());
        
        $result = $this->presumptiveService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive Info is Edited", $result)
        );
    }
    
    public function searchByPreviousCode(){
        
         $validate_result = $this->validateData([
            "index_case_no" => "required",
            "index_case_year" => "required",
            "index_case_monopoly"=>"required",
            "township_id" => "required",
        ], request()->all());
        // $validate_result = $this->validateData([
        //     "previousID" => "required",
        // ], request()->all());

        if ($validate_result) return $this->showValidateError();

        $result = $this->presumptiveService->getByPreviousCode(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive by Previous Code", $result)
        );
    }

    public function addNew()
    {
        // // $validate_result = $this->validateData([
        // //     'name' => 'required',
        // //     'sex' => 'required',
        // //     'age' => 'required',
        //    // 'no' => 'required',
        //     // 'reg_date' => 'required',
        //     // 'case_found_at' => 'required',
        //     // 'referral_type_id' => 'required',
        //     // 'referral_from_id' => 'required',
        //     // 'symptons' => 'required',
        //     // 'risk_factors' => 'required',
        //     // 'hiv_status' => 'required',
        //     // 'sputum_status' => 'required',
        //     // 'cxr_status' => 'required',
        //     // 'gene_xpert_status' => 'required',
        //     // 'culture_status' => 'required',
        //     // 'dst_status' => 'required',
        //     // 'other_investigation_status' => 'required',
        //     // 'conclusion' => 'required',
        //     'township_id' => 'required',
        // ], request()->all());

        // if ($validate_result) return $this->showValidateError();

        $result = $this->presumptiveService->addNew(request()->all());
        
        $result = $this->presumptiveService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "New Presumptive is Saved", $result)
        );
    }
    
    public function storeCi()
    {
          $data=request()->all();

        try {
                $data=request()->all();
            
              //if Community   /n_o_attendence_male
              if(isset($data['community_forms']))
              {
                  
                  $communities=$data['community_forms'];
                  $ciData=$data['ciData'];
                  
                 $screening_person=$ciData['screening_person'];
                //  $symptom_screening=$ciData['community_symptom_screening'];
                 $screening_township_id=$ciData['screening_township_id'];
                 $date=$ciData['date'];
                 $place=$ciData['place'];
                 $volunteer_id=$ciData['volunteer_id'];
                 $month=$ciData['month'];
                 $year=$ciData['year'];
                 $type=$ciData['type'];
                 
                 $township_id=$communities[0]['township_id'];
                 
                  //store in HE activity
                  $data_collect=collect($data['community_forms']);
          
                  $n_o_attendence_male = $data_collect->where('community_symptom_screening',2)->where('sex', 1)->count();
                  $n_o_attendence_female=$data_collect->where('community_symptom_screening',2)->where('sex', 2)->count();
                  
                  $total_refer_male = $data_collect->where('community_refer', 2)->where('sex', 1)->count();
                  $total_refer_female=$data_collect->where('community_refer', 2)->where('sex', 2)->count();
          
                   $he_activity=\App\Models\HeActivity::create([
                    'n_o_attendence_male' => $n_o_attendence_male,
                    'n_o_attendence_female' => $n_o_attendence_female,
                    
                    'refer_male'=>$total_refer_male,
                    'refer_female'=>$total_refer_female,
                    
                    'screening_person'=>$screening_person,
                   
                    'township_id'=>$township_id,
                
                    'volunteer_id'=>$volunteer_id,
                    'type'=>$type,
                    'place'=>$place,
                    'date'=>$date,
                    'month'=>$month,
                    'year'=>$year, 
                     ]);
                
                   $he_activity_id = $he_activity->id;
                  
                  foreach($communities as $d)
                  {
                    try {
                        DB::beginTransaction();
                       
                        // Save to the presumptive table
                        $presumptive = \App\Models\Presumptive::create([
                            'name'=>$d['name'],
                            'age'=>$d['age'],
                            'sex'=>$d['sex'],
                            'case_found_at' => 4,
                            'confirm'=>1,
                            'township_id' => $township_id,
                        ]);
                    
                      
                        $presumptive_id = $presumptive->id;
                    
                        // Save to the CI table using the ID from the presumptive table
                        
                        \App\Models\Ci::create([
                            'presumptive_id' => $presumptive_id,
                             'date' => $date,
                            'screening_person' => $screening_person,
                            'symptom_screening' => $d['community_symptom_screening'],
                             'refer' => $d['community_refer'],
                             'type'=>$type,
                             'township_id'=>$township_id,
                             'screening_township_id'=>$screening_township_id,
                             'volunteer_id'=>$volunteer_id,
                             'he_activity_id'=>$he_activity_id,
                            
                        ]);
                    
                        DB::commit();
                      
        
                    } catch (\Exception $e) {
                        DB::rollback();
                       return $e->getMessage();
                    }

                  }
                  
                  
              }else{
                  
                    $data_collect=collect($data);
                  
                    $type= $data_collect[0]['type'];
                    $screening_person= $data_collect[0]['screening_person'];
                     //$refer= $data_collect[0]['refer'];
                    $place=$data_collect[0]['place'];
                    $date=$data_collect[0]['ci_date'];
                    $month=$data_collect[0]['month'];
                    $year=$data_collect[0]['year'];
                    $township_id=$data_collect[0]['township_id'];
                    $index_case_no=$data_collect[0]['index_case_no'];
                    $index_case_year=$data_collect[0]['index_case_year'];
                    $monopoly=$data_collect[0]['index_case_monopoly']=='No'?1:2;
                    $supporting_township_id=$data_collect[0]['supporting_township_id']; //township for volunteer to save in HE table
                    $volunteer_id=$data_collect[0]['volunteer_id'];
                    
                    $total_refer_male = $data_collect->where('sex',1)->where('refer', 2)->count();
                    $total_refer_female = $data_collect->where('sex',2)->where('refer', 2)->count();
          
                    //for HE table to store
                    
                    $n_o_household_male = $data_collect->where('symptom_screening',2)->where('relationship', 1)->where('sex', 1)->count();
                    $n_o_household_female = $data_collect->where('symptom_screening',2)->where('relationship', 1)->where('sex', 2)->count();
                    
                    $n_o_closecontact_male= $data_collect->where('symptom_screening',2)->where('relationship','=',3)->where('sex', 1)->count();
                    $n_o_closecontact_female = $data_collect->where('symptom_screening',2)->where('relationship','=',3)->where('sex', 2)->count();
                    
                    // ->where('case_found_at',3)
                   
                    //store in HE activity
                    
                    $he_activity=\App\Models\HeActivity::create([
                                'n_o_household_male' => $n_o_household_male,
                                'n_o_household_female' => $n_o_household_female,
                                'n_o_closecontact_male' => $n_o_closecontact_male,
                                'n_o_closecontact_female' => $n_o_closecontact_female,
                                'refer_male'=>$total_refer_male,
                                'refer_female'=>$total_refer_female,
                                'screening_person'=>$screening_person,
                                'index_case_no'=>$index_case_no,
                                 'index_case_year'=>$index_case_year,
                                 'monopoly'=>$monopoly,
                                'township_id'=>$township_id,
                                'supporting_township_id'=>$supporting_township_id,
                                'volunteer_id'=>$volunteer_id,
                                'type'=>$type,
                                'place'=>$place,
                                'date'=>$date,
                                'month'=>$month,
                                'year'=>$year,]);
                                
                    $he_activity_id = $he_activity->id;  
                    
                //For CI section
        
                foreach($data as $d)
                {
                    $validate_result = $this->validateData([
                        'ci_date' => 'required',
                        'screening_person' => 'required',
                        'symptom_screening' => 'required',
                         'screening_township_id' => 'required',
                         
                    ], $d);
                    
                     if ($validate_result) return $this->showValidateError();
                
                    $ci=new \App\Models\Ci();
                    $ci->presumptive_id= $d['id'];
                    $ci->date= $d['ci_date'];
                    $ci->screening_person=$d['screening_person'];
                    $ci->symptom_screening=$d['symptom_screening'];
                     $ci->refer=$d['refer'];
                    $ci->patient_id=$d['patient_id']?$d['patient_id']:null;
                    $ci->township_id=$d['township_id']?$d['township_id']:null;
                     $ci->screening_township_id=$d['screening_township_id']?$d['screening_township_id']:null;
                     $ci->type=$d['type'];
                     $ci->volunteer_id=$d['volunteer_id'];
                     $ci->he_activity_id=$he_activity_id;
                     
                    $ci->save();
                }
                   
                return response()->json(
                    $this->custom_response->create(\App\Enums\ResponseCode::Success, true, " Saved")
                );
                  
              }
        
        } catch (\Exception $e) {
           return $e->getMessage();
        }
       
       
       
    }
    
    public function getCi()
    {
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required",
            "township_id" => "required",
        ], request()->all());
        
        if ($validate_result) return $this->showValidateError();
        
        $result =  $this->ciService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All CI Lists",
                $result
            )
        );
    }
    
     public function deleteCi()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->ciService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "CI is deleted", $result)
        );
    }

    public function updateCi()
    {
        $validate_result = $this->validateData([
            'date' => 'required',
            'screening_person' => 'required',
            'symptom_screening' => 'required',
            'id' => 'required',
        ], request()->all());

        if ($validate_result) return $this->showValidateError();

        $result = $this->ciService->editInfo(request()->all());
        $result = $this->ciService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "CI Info is Edited", $result)
        );
    }

    public function get()
    {
        $result = $this->presumptiveService->getAll(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive List", $result)
        );
    }
    
    public function getSupportingTownshipPresumptive()
    {
        $result = $this->presumptiveService->getSupportingTownshipPresumptive(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Supporting Township Presumptive List", $result)
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->presumptiveService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive by " . request("column"), $result)
        );
    }
    
    public function getEachCi()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->ciService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Family Member by " . request("column"), $result)
        );
    }
    
    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->presumptiveService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Presumptive is deleted", $result)
        );
    }
    
    public function ci_export()
    {
        //   $this->ci= new \App\Service\DA\Ci;
        //   $request=request()->all();
        //   $cis=$this->ci->getExport($request);
        //   return $cis;
          
        $mytime = \Carbon\Carbon::now(); 
        return Excel::download(new \App\Exports\CiExport(request()->all()), 'CiExport'.$mytime->toDateTimeString().'.csv');
    }
}
