<?php

namespace App\Http\Controllers\DA;

use App\Http\Controllers\Controller;

class PreEnrollSupportController extends Controller
{
    private $preEnrollSupportService;

    public function __construct()
    {
        parent::__construct();
        $this->preEnrollSupportService = new \App\Service\DA\PreEnrollSupport;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'patient_id' => 'required',
            'nominated' => 'required',
            'support_month' => 'required',
            'support_year' => 'required',
            'month_type' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();


        $errorResponse = $this->preEnrollSupportService->checkError(request()->all);
        if ($errorResponse["success"] == true) {
            $result = $this->preEnrollSupportService->save(request()->all());
            $result = $this->preEnrollSupportService->getEach("id", $result->id);
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patient Pre-Enroll Support is Saved", $result)
            );
        }
        else {
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::ValidationFailed, false, $errorResponse["message"] , [])
            );
        }
    }



    public function get()
    {
        $result =  $this->preEnrollSupportService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Pre Enroll Supports",
                $result
            )
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'support_month' => 'required',
            'support_year' => 'required',
            'nominated' => 'required',
            
            'id' => 'required'
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->preEnrollSupportService->update(request()->all());
        $result = $this->preEnrollSupportService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Volunteer is edited", $result)
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->preEnrollSupportService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Pre Enroll by " . request("column"), $result)
        );
    }

    // public function update()
    // {
    //     $validate_result = $this->validateData([
    //         'name' => 'required',
    //         'sex' => 'required',
    //         'age' => 'required',
    //         'address' => 'required',
    //         'gene_result' => 'required',
    //         'lab_code' => 'required',
    //         'date' => 'required',
    //         'pre_enroll' => 'required',
    //         'id'=>'required'


    //     ], request()->all());
    //     if ($validate_result) return $this->showValidateError();

    //     $result = $this->preEnrollSupportService->update(request()->all());
    //     $result = $this->preEnrollSupportService->getEach("id", request("id"));
    //     return response()->json(
    //         $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patient is Saved", $result)
    //     );
    // }


    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->preEnrollSupportService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Pre-enroll is deleted", $result)
        );
    }
}
