<?php

namespace App\Http\Controllers\DA;

use App\Http\Controllers\Controller;

class PatientMDRTBRegimentController extends Controller
{
    private $mdrtbRegimentService;

    public function __construct()
    {
        parent::__construct();
        $this->mdrtbRegimentService = new \App\Service\DA\PatientMDRTBRegiment;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'patient_id' => 'required',
            'mdrtb_regiment_id' => 'required',
            'date' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->mdrtbRegimentService->save(request()->all());
        $result = $this->mdrtbRegimentService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "MDRTB Regiment is Saved", $result)
        );
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "patient_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->mdrtbRegimentService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All MDRTB Regiment Activities",
                $result
            )
        );
    }

    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->mdrtbRegimentService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "MDRTB Regiment by " . request("column"), $result)
        );
    }

    

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->mdrtbRegimentService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "MDRTB Regiment is deleted", $result)
        );
    }
}
