<?php

namespace App\Http\Controllers\DA;

use App\Http\Controllers\Controller;

class PatientController extends Controller
{
    private $patientService;

    public function __construct()
    {
        parent::__construct();
        $this->patientService = new \App\Service\DA\Patient;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'sex' => 'required',
            'dob' => 'required',
            'address' => 'required',
            'pre_enroll' => 'required',


        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->patientService->save(request()->all());
        $result = $this->patientService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patient is Saved", $result)
        );
    }



    public function get()
    {
        $result =  $this->patientService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All patients",
                $result
            )
        );
    }

    public function export(){
        return response(request()->all())->json();
       $result =  $this->patientService->getAll(request()->all(),true);
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All patients exported list",
                $result
            )
        );
    }

    public function getEach()
    {
        
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->patientService->getEach(request("column"), request("value"));
       
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patient by " . request("column"), $result));
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'sex' => 'required',
            'dob' => 'required',
            'address' => 'required',
            'pre_enroll' => 'required',
            'id'=>'required'


        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->patientService->update(request()->all());
        $result = $this->patientService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patient is Saved", $result)
        );
    }


    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->patientService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patient is deleted", $result)
        );
    }
    
     public function getByIndexCode()
    {
        $result =  $this->patientService->getByIndexCode(request()->all());
      
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All patients",
                $result
            )
        );
    }
    
 


}
