<?php

namespace App\Http\Controllers\DA;

use App\Http\Controllers\Controller;

class HomeVisitActivityController extends Controller
{
    private $homeVisitService;

    public function __construct()
    {
        parent::__construct();
        $this->homeVisitService = new \App\Service\DA\HomeVisit;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'type' => 'required',
            'patient_id' => 'required',
            'date' => 'required',
            'se_checklist' => 'required',
            'infection_control' => 'required',
            'outside_township' => 'required',
            'month' => 'required',
            'year' => 'required',
            'township_id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->homeVisitService->save(request()->all());
        $result = $this->homeVisitService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "He is Saved", $result)
        );
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required",
            "township_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->homeVisitService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All HE Activities",
                $result
            )
        );
    }

    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->homeVisitService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "HE by " . request("column"), $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'type' => 'required',
            'patient_id' => 'required',
            'date' => 'required',
            'se_checklist' => 'required',
            'infection_control' => 'required',
            'month' => 'required',
            'year' => 'required',
            'id' => 'required'
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->homeVisitService->update(request()->all());
        $result = $this->homeVisitService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "HE is Saved", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->homeVisitService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "HE is deleted", $result)
        );
    }
}
