<?php

namespace App\Http\Controllers\DA;

use App\Http\Controllers\Controller;

class HeActivityController extends Controller
{
    private $heService;

    public function __construct()
    {
        parent::__construct();
        $this->heService = new \App\Service\DA\He;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'month' => 'required',
            'year' => 'required',
            'type' => 'required',
            'screening_person' => 'required',
            'date' => 'required',
            'place' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->heService->save(request()->all());
        $result = $this->heService->getEach("id", $result->id);
      
        return response()->json(
           
             $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "He is Saved", $result)
        );
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required",
            "township_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->heService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All HE Activities",
                $result
            )
        );
    }

    public function getEach()
    {

        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->heService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "HE by " . request("column"), $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'type' => 'required',
            'screening_person' => 'required',
            'date' => 'required',
            'place' => 'required',
            'id' => 'required'
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->heService->update(request()->all());
        $result = $this->heService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "HE is Saved", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->heService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "HE is deleted", $result)
        );
    }
}
