<?php

namespace App\Http\Controllers\DA;

use App\Http\Controllers\Controller;

class FamilyMemberController extends Controller
{
    private $familyMemberService;

    public function __construct()
    {
        parent::__construct();
        $this->familyMemberService = new \App\Service\DA\FamilyMember;
        $this->presumptiveService = new \App\Service\DA\Presumptive;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'sex' => 'required',
            'age' => 'required',
            'patient_id' => 'required',
        ], request()->all());
        
        if ($validate_result) return $this->showValidateError();

        $result = $this->familyMemberService->save(request()->all());
        
        // if($result['index_case_no']==null ||$result['index_case_no']==0 || $result['index_case_year']==null || $result['index_case_year']==0)
        // {
            
        //   return response()->json(
        //         $this->custom_response->create(\App\Enums\ResponseCode::Error, false, "No index case no or index case year")
        //     );
        // }
        
        $result = $this->familyMemberService->getEach("id", $result->id);
        
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Family Member is Saved", $result)
        );
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "patient_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->familyMemberService->getAll(request()->all());

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Family Member by patient ID " . request("patient_id"), $result)
        );
    }


    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->familyMemberService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Family Member by " . request("column"), $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'name' => 'required',
            'sex' => 'required',
            'age' => 'required',
            'id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->familyMemberService->update(request()->all());
        $result = $this->familyMemberService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Family Member is updated", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->familyMemberService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Family Member is deleted", $result)
        );
    }

    public function savePresumptive()
    {
        $validate_result = $this->validateData([
            'no' => 'required',
            'reg_date' => 'required',
            'referral_type_id' => 'required',
            'referral_from_id' => 'required',
            'symptons' => 'required',
            'risk_factors' => 'required',
            'hiv_status' => 'required',
            'sputum_status' => 'required',
            'cxr_status' => 'required',
            'gene_xpert_status' => 'required',
            'culture_status' => 'required',
            'dst_status' => 'required',
            'other_investigation_status' => 'required',
            'conclusion' => 'required',
            'township_id' => 'required',
            'id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->presumptiveService->saveAsPresumptive(request()->all());
        $result = $this->presumptiveService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Family Member is Saved", $result)
        );
    }

}
