<?php

namespace App\Http\Controllers\DA;

use App\Http\Controllers\Controller;

class EnrollSupportController extends Controller
{
    private $enrollSupportSerivce;

    public function __construct()
    {
        parent::__construct();
        $this->enrollSupportSerivce = new \App\Service\DA\EnrollSupport;
        $this->patientService = new \App\Service\PA\Patient;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'patient_id' => 'required',
            'nominated' => 'required',
            'support_month' => 'required',
            'support_year' => 'required',



        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $errorResponse = $this->enrollSupportSerivce->checkError(request()->all);
        if ($errorResponse["success"] == true) {
            $result = $this->enrollSupportSerivce->save(request()->all());
            $result = $this->enrollSupportSerivce->getEach("id", $result->id);
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Patient Enroll Support is Saved", $result)
            );
        } else {
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::ValidationFailed, false, $errorResponse["message"], [])
            );
        }
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->enrollSupportSerivce->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Enroll by " . request("column"), $result)
        );
    }


    public function get()
    {
        $result =  $this->enrollSupportSerivce->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Enroll Supports",
                $result
            )
        );
    }

    public function updateInformation()
    {
        $validate_result = $this->validateData([
            'outside_tsp' => 'required',
            't_in' => 'required',
            'tb_hive_info' => 'required',
            'mdrtb_reg_no' => 'required',
            'mdrtb_reg_year' => 'required',
            'mdrtb_monopoly'=>'required',
            'type_of_patient' => 'required',
            'type_of_tb' => 'required',
            'comorbid_diseases' => 'required',
            'hiv_status' => 'required',
            'id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $errorResponse = $this->patientService->checkEnrollInfoError(request()->all);
        if ($errorResponse["success"] == true) {
            $result = $this->patientService->updateSupportInformation(request()->all());
            $result = $this->patientService->getEach("id", request("id"));
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Enroll Information is Saved", $result)
            );
        } else {
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::ValidationFailed, false, $errorResponse["message"], [])
            );
        }
    }

    public function updateFinishInformation()
    {
        $validate_result = $this->validateData([
            // 'treatment_finish' => 'required',
            // 'finished_date' => 'required',
            // 'final_outcome' => 'required',
            // 'final_outcome_date' => 'required',
            'id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->patientService->updateFinishInformation(request()->all());
        $result = $this->patientService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Enroll Information is Saved", $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'id' => 'required',
            'nominated' => 'required',
            'support_month' => 'required',
            'support_year' => 'required',

        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->enrollSupportSerivce->update(request()->all());
        $result = $this->enrollSupportSerivce->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, " Enroll Support is Saved", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->enrollSupportSerivce->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Pre-enroll is deleted", $result)
        );
    }
}
