<?php

namespace App\Http\Controllers\DA;

use App\Http\Controllers\Controller;

class DOTSVolunteerController extends Controller
{
    private $dotsVolunteerController;

    public function __construct()
    {
        parent::__construct();
        $this->dotsVolunteerController = new \App\Service\PA\DOTSVolunteer;
    }


    public function get()
    {
        $result =  $this->dotsVolunteerController->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All DOTS Volunteer",
                $result
            )
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->dotsVolunteerController->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS  Volunteer by " . request("column"), $result)
        );
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'volunteer_id' => 'required',
            'dots_patient_id' => 'required',
            'dots_app_status' => 'required'
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->dotsVolunteerController->save(request()->all());
        $result = $this->dotsVolunteerController->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Volunteer is saved", $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'volunteer_id' => 'required',
            'dots_patient_id' => 'required',
            'dots_app_status' => 'required',
            'id' => 'required'
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->dotsVolunteerController->update(request()->all());
        $result = $this->dotsVolunteerController->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Volunteer is Update", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->dotsVolunteerController->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "DOTS Volunteer is deleted", $result)
        );
    }
}
