<?php

namespace App\Http\Controllers\DA;

use App\Http\Controllers\Controller;

class CounselingActivityController extends Controller
{
    private $counselingService;

    public function __construct()
    {
        parent::__construct();
        $this->counselingService = new \App\Service\DA\Couseling;
    }

    public function store()
    {
        $validate_result = $this->validateData([
            'month' => 'required',
            'year' => 'required',
            'date' => 'required',
            'phone' => 'required',
            'patient_id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->counselingService->save(request()->all());
        $result = $this->counselingService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Counseling is Saved", $result)
        );
    }

    public function get()
    {
        $validate_result = $this->validateData([
            "month" => "required",
            "year" => "required",
            "township_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result =  $this->counselingService->getAll(request()->all());
        return response()->json(
            $this->custom_response->create(
                \App\Enums\ResponseCode::Success,
                true,
                "All Counseling Activities",
                $result
            )
        );
    }

    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->counselingService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Counseling by " . request("column"), $result)
        );
    }

    public function update()
    {
        $validate_result = $this->validateData([
            'date' => 'required',
            'phone' => 'required',
            'patient_id' => 'required',
            'id' => 'required',
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->counselingService->update(request()->all());
        $result = $this->counselingService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Counseling is Saved", $result)
        );
    }

    public function delete()
    {
        $validate_result = $this->validateData([
            "id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->counselingService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Counseling is deleted", $result)
        );
    }
}
