<?php

namespace App\Http\Controllers\Clinic;

use App\Http\Controllers\Controller;

class VisitController extends Controller
{
    private $visitService;
    public function __construct()
    {
        parent::__construct();
        $this->visitService = new \App\Service\Clinic\Visit;
    }

    public function getAll()
    {
        $validate_result = $this->validateData([
            "clinic_patient_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->visitService->getAll();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Visits by patient", $result)
        );
    }


    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->visitService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Visits by " . request("column"), $result)
        );
    }

    public function store()
    {
        $result = $this->visitService->store();
        $result = $this->visitService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Visit is Saved", $result)
        );
    }

    public function update()
    {
        $result = $this->visitService->update();
        $result = $this->visitService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Visit is Updated", $result)
        );
    }

    public function delete()
    {
        $result = $this->visitService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Clinic Patient Visit is deleted", $result)
        );
    }
}
