<?php

namespace App\Http\Controllers\Clinic;

use App\Http\Controllers\Controller;

class TreatmentController extends Controller
{
    private $treatmentService;
    public function __construct()
    {
        parent::__construct();
        $this->treatmentService = new \App\Service\Clinic\Treatment;
    }

    public function getAll()
    {
        $validate_result = $this->validateData([
            "clinic_patient_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->treatmentService->getAll();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Treatment by patient", $result)
        );
    }


    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->treatmentService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Treatment by " . request("column"), $result)
        );
    }

    public function store()
    {
        $result = $this->treatmentService->store();
        $result = $this->treatmentService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Treatment is Saved", $result)
        );
    }

    public function update()
    {
        $result = $this->treatmentService->update();
        $result = $this->treatmentService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Treatment is Updated", $result)
        );
    }

    public function delete()
    {
        $result = $this->treatmentService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Clinic Patient Treatment is deleted", $result)
        );
    }
}
