<?php

namespace App\Http\Controllers\Clinic;

use App\Http\Controllers\Controller;

class TreatmentChangeController extends Controller
{
    private $treatmentChangeService;
    public function __construct()
    {
        parent::__construct();
        $this->treatmentChangeService = new \App\Service\Clinic\TreatmentChange;
    }

    public function getAll()
    {
        $validate_result = $this->validateData([
            "clinic_patient_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->treatmentChangeService->getAll();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Treatment Changes by patient", $result)
        );
    }


    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->treatmentChangeService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Treatment Changes by " . request("column"), $result)
        );
    }

    public function store()
    {
        $result = $this->treatmentChangeService->store();
        $result = $this->treatmentChangeService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Treatment Change is Saved", $result)
        );
    }

    public function update(){
        $result = $this->treatmentChangeService->update();
        $result = $this->treatmentChangeService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Treatment Change is Updated", $result)
        );
    }

    public function delete(){
        $result = $this->treatmentChangeService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Clinic Patient is deleted", $result)
        );
    }

}
