<?php

namespace App\Http\Controllers\Clinic;

use App\Http\Controllers\Controller;

class PostTreatmentController extends Controller
{
    private $postTreatmentService;
    public function __construct()
    {
        parent::__construct();
        $this->postTreatmentService = new \App\Service\Clinic\PostTreatment;
    }

    public function getAll()
    {
        $validate_result = $this->validateData([
            "clinic_patient_id" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();
        $result = $this->postTreatmentService->getAll();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Post Treatment by patient", $result)
        );
    }


    public function getEach()
    {
        $validate_result = $this->validateData([
            "column" => "required",
            "value" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->postTreatmentService->getEach(request("column"), request("value"));

        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Post Treatment by " . request("column"), $result)
        );
    }

    public function store()
    {
        $result = $this->postTreatmentService->store();
        $result = $this->postTreatmentService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Post Treatment is Saved", $result)
        );
    }

    public function update()
    {
        $result = $this->postTreatmentService->update();
        $result = $this->postTreatmentService->getEach("id", request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Post Treatment is Updated", $result)
        );
    }

    public function delete()
    {
        $result = $this->postTreatmentService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Post Treatment is deleted", $result)
        );
    }
}
