<?php

namespace App\Http\Controllers\Clinic;

use App\Http\Controllers\Controller;

class PatientController extends Controller
{
    private $clinicPatientService;
    public function __construct()
    {
        parent::__construct();
        $this->clinicPatientService = new \App\Service\Clinic\Patient;
    }

    public function store()
    {
        $result = $this->clinicPatientService->store();
        $result = $this->clinicPatientService->getEach("id", $result->id);
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Clinic Patient is Saved", $result)
        );
    }

    public function update(){
        $result = $this->clinicPatientService->update();
        $result = $this->clinicPatientService->getEach("id",request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Clinic Patient is Updated", $result)
        );
    }

    public function getAll(){
        $result = $this->clinicPatientService->getAll();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Clinic Patients", $result)
        );
    }

    public function getEach(){
        $result = $this->clinicPatientService->getEach("id",request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Clinic Patients", $result)
        );
    }

    public function delete()
    {
        $result = $this->clinicPatientService->delete(request("id"));
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Clinic Patient is deleted", $result)
        );
    }
}
