<?php

namespace App\Http\Controllers\Clinic;

use App\Http\Controllers\Controller;

class LoginController extends Controller
{
    private $clinicAuthService;

    public function __construct()
    {
        parent::__construct();
        $this->clinicAuthService = new \App\Service\Clinic\Auth;
    }

    public function login()
    {

        $validate_result = $this->validateData([
            "name" => "required",
            "password" => "required",
        ], request()->all());
        if ($validate_result) return $this->showValidateError();

        $result = $this->clinicAuthService->login(request()->all());
        if (!$result) {
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::LoginedFailed, false, "Login Failed")
            );
        } else {
            $tokenResult = $result->createToken('Clinic Access Token');
            return response()->json(
                $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Login Success", array(
                    "token" => $tokenResult->accessToken
                ))
            );
        }
    }

    public function getYour()
    {
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Your Information", array(
                "user" => $this->clinicAuthService->getYour()
            ))
        );
    }

    public function logout()
    {
        request()->user()->OauthAcessToken()->delete();
        return response()->json(
            $this->custom_response->create(\App\Enums\ResponseCode::Success, true, "Logout successfully")
        );
    }
}
