<?php
namespace App\Exports;

use App\Patient;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Events\AfterSheet;

class PatientListExport implements FromCollection, WithHeadings,WithEvents
{
    protected $request;
    
    public function __construct($request)
    {
        $this->request = $request;
        
        $this->patientService = new \App\Service\Dashboard\Patient;
       $this->result =  $this->patientService->getExcelExportData($request,true);
    }
    
    // public function registerEvents(): array
    // {
    //     return [
    //         AfterSheet::class => function(AfterSheet $event) {
    //             $event->sheet->mergeCells('N1:U1'); //  Multiple Columns
    //             $event->sheet->mergeCells('V1:W1');
    //         },
    //     ];
    // }
    
    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                 $event->sheet->mergeCells('I1:Q1');
            }
        ];
    }
    
   
    
    public function headings(): array
    {
        //  [ ' ', ' ' , ' ', ' ' , ' ', ' ' , ' ', ' ' , '2021 Jan-Mar Pre Enroll','2021 Apr-Jun Pre Enroll',' ', ' ' , ' ', ' ' , ' ', ' ' , ' ', ' ' , ' ', ' ' , ' ' ,' ' , ' ',],
        return [
                ['2021 Jan-Mar Pre Enroll','2021 Apr-Jun Pre Enroll'],
             [
                'No',
                'Name',
                'DOB',
                'Age',
                'Sex',
                'Address',
                'Township',
                 'Pre-Enroll',
                
                'Pre Month 1',
                'Pre Year 1',
                'Pre Support 1',
                'Pre Date 1',
                'Pre Type 1',
                'Pre Norminated 1',
                'Pre Norminated Month 1',
                'Pre Norminated Year 1',
                
                'Xpert Code',
                'Lab Test Name',
                'Lab Code',
                'Lab Date',
                'Lab Result',
               
                
                'Pre Month 2',
                'Pre Year 2',
                'Pre Support 2',
                'Pre Date 2',
                'Pre Type 2',
                'Pre Norminated 2',
                'Pre Norminated Month 2',
                'Pre Norminated Year 2',
                
                'Outside Township',
                'Transfer In',
                'Type Of Patient',
                'Type Of TB',
                'LPA Result',
                'LPA Date',
                'Culture Result',
                'Culture Date',
                'CXR Date',
                'CXR Result',
                'Number Of Family Members'
               ] ,
        ];
      
    }

    public function collection()
    {
        return $this->result;
    }
}
