<?php

namespace App\Exports;

use App\SideEffect;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class SideEffectExport implements WithColumnFormatting,FromView,ShouldAutoSize
{
    protected $request;
    protected $sympton_model;
    protected $risk_factor_model;

    public function __construct($request=null)
    {
        $this->request = $request;
        $this->homeVisitService = new \App\Service\Dashboard\HomeVisit;
    }

    public function view(): View
    {
        $request=$this->request;
        $side_effect=$this->homeVisitService->export($request);
        return view("exports.side_effect",array(
            "side_effects"=>$side_effect,
        ));
    }

    public function columnFormats(): array
    {
        return [
            'AG' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AK' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AN' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AQ' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AT' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AW' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AZ' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            
            
        ];
    }


}