<?php

namespace App\Exports;

use App\Presumptive;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class PresumptiveExport implements WithColumnFormatting,FromView,ShouldAutoSize
{
    protected $request;
    protected $sympton_model;
    protected $risk_factor_model;

    public function __construct($request=null)
    {
        $this->request = $request;
        $this->model= new \App\Service\DA\PresumptiveDiagnosis;
    }

     public function view(): View
    {
        $request=$this->request;
        $presumptive=$this->model->getExcelExportData($this->request->all());
        return view("exports.presumptive",array(
            "presumptives"=>$presumptive,
        ));
    }

    public function columnFormats(): array
    {
        return [
            'L' => NumberFormat::FORMAT_TEXT,
            'R' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AK' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AT' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AW' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AZ' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'O' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            
            
        ];
    }


}