<?php

namespace App\Exports;

use App\Patient;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Illuminate\Support\Facades\Auth;

class PatientListExport implements WithColumnFormatting,FromView,ShouldAutoSize
{
    protected $request;

    public function __construct($request)
    {
        $this->request = $request;

        $this->patientService = new \App\Service\Dashboard\Patient;
    }
    
    public function view(): View
    {
       
        $this->result =  $this->patientService->getExcelExportData($this->request);
         return view("exports.patient_list_export",array(
            "patients"=>$this->result,
        ));
        
    }
    
   

    public function columnFormats(): array
    {
        return [
            
            'AK' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AN' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AQ' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AT' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AW' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AZ' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            
            
        ];
    }


}