<?php

namespace App\Exports;

use App\HeActivity;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Illuminate\Support\Facades\Auth;

class HEActivityExport implements WithColumnFormatting,FromView,ShouldAutoSize
{
    protected $request;

    public function __construct($request)
    {
        $this->request = $request;

        $this->model= new \App\Service\Dashboard\DOTSPatient;
        $this->dotspatients=new \App\Models\DOTSPatient();
         $this->heService = new \App\Service\PA\He;
        // $this->heService = new \App\Service\DA\He;
    }
    
    public function view(): View
    {
        
         $result =  $this->heService->getAll($this->request);
           
         return view("exports.HEactivity",array(
            "result"=>$result,
        ));
        
    }
    
   

    public function columnFormats(): array
    {
        return [
            'AG' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AK' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AN' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AQ' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AT' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AW' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AZ' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            
            
        ];
    }


}