<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;


class Form7Export implements FromView, ShouldAutoSize
{
    protected $data;
    protected $authUser;

    public function __construct($data)
    {
        $this->data = $data;
        $this->authUser = $data;
    }

    public function view(): View
    {
        return view('exports.report.form7', [
            'data' => $this->data,
            'authUser' => $this->authUser,
        ]);
    }
}
