<?php

namespace App\Exports;

use App\Outcome;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class OutcomeIssueExport implements WithColumnFormatting,FromView,ShouldAutoSize
{
    protected $request;
    protected $sympton_model;
    protected $risk_factor_model;

    public function __construct($request=null)
    {
        $this->request = $request;
    }

    public function view(): View
    {
        $request=$this->request;
        
        $model = new \App\Models\Patient();
        $issue_exports = $model->whereBetween('issue_date', [$this->request->issue_from_date, $this->request->issue_to_date]);
        
        if($this->request->township_group_id==6)
        {
            $issue_exports =  $issue_exports->with([
                                    "mdrtbRegiments" => function ($query) {
                                    $query->orderBy("created_at", "desc");
                                },"township"])->get();
        }else{
            $issue_exports =  $issue_exports->whereHas("township",function($query){
                $query->where("township_group_id",$this->request->township_group_id);
                })->with([
                    "mdrtbRegiments" => function ($query) {
                    $query->orderBy("created_at", "desc");
                },"township"])->get();
        }
        
        return view("exports.issue_export",array(
            "issue_exports"=>$issue_exports,
        ));
    }

    public function columnFormats(): array
    {
        return [
            'AG' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AK' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AN' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AQ' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AT' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AW' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AZ' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            
            
        ];
    }


}