<?php

namespace App\Exports;

use App\FamilyMember;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class FamilyMemberExport implements WithColumnFormatting,FromView,ShouldAutoSize
{
    protected $request;
    protected $sympton_model;
    protected $risk_factor_model;
    
    
    public function __construct($request=null)
    {
        $this->request = $request;
        $this->model= new \App\Service\Dashboard\Patient;
        $this->familymember= new \App\Service\DA\Patient;
    }

     public function view(): View
    {
        $request=$this->request;
        
        if( isset($request['township_group_id'])){
             $familymembers=$this->familymember->getFamilymember($request);
            return view("exports.familymember",array(
                "familymembers"=>$familymembers,
            ));
        }
        $familymembers=$this->model->getFamilymember($request);
        return view("exports.familymember",array(
            "familymembers"=>$familymembers,
        ));
    }
    
    

    public function columnFormats(): array
    {
        return [
            'A' => NumberFormat::FORMAT_TEXT,
             'B' => NumberFormat::FORMAT_TEXT,
             'F' => NumberFormat::FORMAT_TEXT, 
        ];
    }


}