<?php

namespace App\Exports;

use App\HeActivity;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class DashboardHEActivityExport implements WithColumnFormatting,FromView,ShouldAutoSize
{
    protected $request;

    public function __construct($request)
    {
        $this->request = $request;
         $this->heService = new \App\Service\Dashboard\He;
    }
    
    public function view(): View
    {
        
         $result =  $this->heService->getAll( $this->request);
           
         return view("exports.HEactivity",array(
            "result"=>$result,
        ));
        
    }
    
   

    public function columnFormats(): array
    {
        return [
            'AK' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AN' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AQ' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AT' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AW' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AZ' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            
            
        ];
    }


}