<?php

namespace App\Exports;

use App\DOTSPatient;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class DOTSPatientExport implements WithColumnFormatting,FromView,ShouldAutoSize
{
    protected $request;

    public function __construct($request)
    {
        $this->request = $request;

        $this->model= new \App\Service\Dashboard\DOTSPatient;
        $this->dotspatients=new \App\Models\DOTSPatient();
    }
    
    public function view(): View
    {
        $request=$this->request;
        $from=$request->dots_startdate_from;
        $to=$request->dots_startdate_to;
      
        $fmonth = date('m', strtotime(date($from))); 
        $tmonth = date('m', strtotime(date($to)));
        $fyear = date('Y', strtotime($from)); 
        $tyear = date('Y', strtotime($to)); 
        
        //$dotspatients=$this->model->getExcelExportData($request);
    
        $dotspatients=new \App\Models\DOTSPatient();
        
        $dotspatients=$dotspatients->with([
                            "patient" => function ($query) {
                                $query->with([
                                    "mdrtbRegiments"]);
                            }, "volunteer"
                        ]);
                        
        if(isset($request->township_group_id))
        {
            $township_group_id=$request->township_group_id;
            
             if($request->township_group_id==6)
                {
                    $township_group_id=$request->township_group_id;
                    
                     $dotspatients->whereHas("patient", function ($query){
                        $query->whereHas("township",function($query){
                            $query->whereIn('township_group_id', [1, 2]);
                           
                        });
                    });
                    
                }else{
                         $dotspatients->whereHas("patient", function ($query)use ($township_group_id){
                         $township_group_id=$township_group_id;
                        $query->whereHas("township",function($query)use ($township_group_id){
                            $query->where("township_group_id",$township_group_id);
                        });
                    });
                }
        }
        else{
             $township_id=$request->township_id;
              $dotspatients->whereHas("patient", function ($query)use($township_id){
                        $query->where('township_id',$township_id);
                    });
        }

        if ($request->dots_app_status==2) {
           
            $dotspatients=$dotspatients->whereHas('dots_visit_date', function ($query)use($from,$to) {
                    $query->whereBetween('date', [$from, $to]);
                });
        }
        
        elseif ($request->dots_app_status==1) {
            $dotspatients=$dotspatients->where('dots_app_status',1)
                                        ->whereHas('dots_visit_report', function ($query)use($fmonth,$tmonth,$fyear,$tyear) {
                                                $query->whereBetween('month',[$fmonth,$tmonth])
                                                        ->whereBetween('year',[$fyear,$tyear]);
                                            });
        }
        else {
            $dotspatients_noapp=$dotspatients->where('dots_app_status',1)
                                        ->whereHas('dots_visit_report', function ($query)use($fmonth,$tmonth,$fyear,$tyear) {
                                                $query->whereBetween('month',[$fmonth,$tmonth])
                                                        ->whereBetween('year',[$fyear,$tyear]);
                                            })->get();
                                            
            $dotspatients_useapp=$this->dotspatients->whereHas('dots_visit_date', function ($query)use($from,$to) {
                    $query->whereBetween('date', [$from, $to]);
                });
                
            if($request->township_group_id!='null')
            {
                $township_group_id=$request->township_group_id;
                
                 if($request->township_group_id==6)
                    {
                        $township_group_id=$request->township_group_id;
                        
                         $dotspatients_useapp->whereHas("patient", function ($query){
                            
                            $query->whereHas("township",function($query){
                                $query->whereIn('township_group_id', [1, 2]);
                               
                            });
                        });
                        
                    }else{
                             $dotspatients_useapp->whereHas("patient", function ($query)use ($township_group_id){
                             $township_group_id=$township_group_id;
                            $query->whereHas("township",function($query)use ($township_group_id){
                                $query->where("township_group_id",$township_group_id);
                            });
                        });
                    }
            }
            
            $dotspatients_useapp=$dotspatients_useapp->get();
                
            $dotspatients=$dotspatients_useapp->concat($dotspatients_noapp);
            
            return view("exports.dotspatients",array(
                "dotspatients"=>$dotspatients,
            ));
        }
        
       
          $dotspatients= $dotspatients->orderBy('created_at', 'asc')->get();
         
         return view("exports.dotspatients",array(
            "dotspatients"=>$dotspatients,
        ));
        
    }
    
   

    public function columnFormats(): array
    {
        return [
            'M' => NumberFormat::FORMAT_NUMBER,
            'AG' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AK' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AN' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AQ' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AT' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AW' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            'AZ' => NumberFormat::FORMAT_DATE_DDMMYYYY,
             'K' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            
            
        ];
    }


}