<?php

namespace App\Exports;

use App\Ci;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class CiExport implements WithColumnFormatting,FromView,ShouldAutoSize
{
    protected $request;
    protected $sympton_model;
    protected $risk_factor_model;

    public function __construct($request=null)
    {
        $this->request = $request;
        $this->model= new \App\Service\Dashboard\Patient;
        $this->ci= new \App\Service\DA\Ci;
    }

     public function view(): View
    {
        $request=$this->request;
        
        if( isset($request['township_group_id'])){
             $cis=$this->ci->getExport($request);
            return view("exports.ci_export",array(
                "cis"=>$cis,
            ));
        }
        // $familymembers=$this->model->getFamilymember($request);
        // return view("exports.familymember",array(
        //     "familymembers"=>$familymembers,
        // ));
    }

    public function columnFormats(): array
    {
        return [
             'B' => NumberFormat::FORMAT_TEXT,
        ];
    }


}